"use client"

import { Page } from "@/types/app";
import { SidebarMenuItem, SidebarMenuButton } from "../ui/sidebar";
import { usePathname } from "next/navigation";
import { NavigationLink } from "./navigation.link";

export function NavigationPage({ title, enabled, icon, url }: Page) {
    const path = usePathname()
    if (!enabled) {
        return;
    }

    const isActive = path === url;
    return (
        <SidebarMenuItem>
            <SidebarMenuButton asChild isActive={isActive} tooltip={title}>
                <NavigationLink href={url}>
                    {icon}
                    <span>{title}</span>
                </NavigationLink>
            </SidebarMenuButton>
        </SidebarMenuItem>
    )
}